/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class BranchCoverage {
    private final List<String> targetLabels = new ArrayList<String>();
    private final List<String> visitedLabels = new ArrayList<String>();

    public BranchCoverage(MethodNode method) {
        AbstractInsnNode[] instructions;
        for (AbstractInsnNode current : instructions = method.instructions.toArray()) {
            if (!(current instanceof LabelNode)) continue;
            this.targetLabels.add(((LabelNode)current).getLabel().toString());
        }
        int lastOpcode = instructions[instructions.length - 1].getOpcode();
        if (lastOpcode != 172 && lastOpcode != 177 && lastOpcode != 176 && lastOpcode != 175 && lastOpcode != 173) {
            this.targetLabels.remove(this.targetLabels.size() - 1);
        }
    }

    public boolean visitLabel(String label) {
        if (!this.targetLabels.contains(label)) {
            return false;
        }
        if (this.visitedLabels.contains(label)) {
            return false;
        }
        this.visitedLabels.add(label);
        return true;
    }

    public boolean visitLabels(List<String> labels) {
        return labels.stream().map(l -> this.visitLabel((String)l)).reduce(false, (a, b) -> a != false || b != false);
    }

    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    public boolean isAllVisited() {
        for (String label : this.targetLabels) {
            if (this.visitedLabels.contains(label)) continue;
            return false;
        }
        return true;
    }
}

