/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tsers.junitquest.ExecutionPath;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.LoggerState;
import org.tsers.junitquest.UtilEquation;
import org.tsers.junitquest.expr.AddNode;
import org.tsers.junitquest.expr.AndNode;
import org.tsers.junitquest.expr.DivisionNode;
import org.tsers.junitquest.expr.EqualNode;
import org.tsers.junitquest.expr.ExprNode;
import org.tsers.junitquest.expr.GetFieldNode;
import org.tsers.junitquest.expr.GreaterThanEqNode;
import org.tsers.junitquest.expr.GreaterThanNode;
import org.tsers.junitquest.expr.InstanceOfNode;
import org.tsers.junitquest.expr.IntNode;
import org.tsers.junitquest.expr.InvokeVirtualNode;
import org.tsers.junitquest.expr.LessThanEqNode;
import org.tsers.junitquest.expr.LessThanNode;
import org.tsers.junitquest.expr.LocalNode;
import org.tsers.junitquest.expr.MinusNode;
import org.tsers.junitquest.expr.MultiplicationNode;
import org.tsers.junitquest.expr.NotEqualNode;
import org.tsers.junitquest.expr.NullNode;
import org.tsers.junitquest.expr.StackNode;

public class Concoler {
    public static BiFunction<ExprNode, ExprNode, ExprNode> getfield = (node, getFieldNode) -> {
        int locationOnStack;
        if (node instanceof StackNode && (locationOnStack = ((StackNode)node).getValue()) == 0) {
            return getFieldNode;
        }
        return node;
    };
    public static BiFunction<ExprNode, String, ExprNode> instanceOf = (node, instanceType) -> {
        int locationOnStack;
        if (node instanceof StackNode && (locationOnStack = ((StackNode)node).getValue()) == 0) {
            return new InstanceOfNode(new StackNode(0), (String)instanceType);
        }
        return node;
    };
    public static Function<ExprNode, ExprNode> cmp = node -> {
        if (Jutil.isSimpleEquation(node)) {
            IntNode cnode = (IntNode)node.getChildren().stream().filter(n -> n instanceof IntNode).findFirst().get();
            if (node instanceof EqualNode) {
                if (cnode.getValue() == -1) {
                    return UtilEquation.stackTopsCondition(LessThanNode.class);
                }
                if (cnode.getValue() == 0) {
                    return UtilEquation.stackTopsCondition(EqualNode.class);
                }
                if (cnode.getValue() == 1) {
                    return UtilEquation.stackTopsCondition(GreaterThanNode.class);
                }
            } else if (node instanceof NotEqualNode) {
                if (cnode.getValue() == -1) {
                    return UtilEquation.stackTopsCondition(GreaterThanNode.class);
                }
                if (cnode.getValue() == 0) {
                    return UtilEquation.stackTopsCondition(NotEqualNode.class);
                }
                if (cnode.getValue() == 1) {
                    return UtilEquation.stackTopsCondition(LessThanNode.class);
                }
            }
        }
        return node;
    };

    public ExprNode concole(ExecutionPath executionPath, ExprNode expr) {
        List<LoggerState> states = executionPath.getStates();
        for (int i = states.size() - 1; i >= 0; --i) {
            LoggerState currentState = states.get(i);
            Optional<LoggerState> previousState = Concoler.getNextState(states, i);
            Function<ExprNode, ExprNode> concoleStepAction = this.concoleStepAction(currentState, previousState);
            expr = concoleStepAction.apply(expr);
        }
        return expr;
    }

    public static Optional<LoggerState> getNextState(List<LoggerState> states, int i) {
        int nextStateIndex = i + 1;
        if (nextStateIndex >= states.size()) {
            return Optional.empty();
        }
        return Optional.of(states.get(nextStateIndex));
    }

    private static boolean isLOAD(int opcode) {
        return Arrays.asList(21, 22, 24, 23, 25).contains(opcode);
    }

    private static boolean isSTORE(int opcode) {
        return Arrays.asList(54, 55, 57, 56, 58).contains(opcode);
    }

    private static boolean isADD(int opcode) {
        return Arrays.asList(96, 97, 99, 98).contains(opcode);
    }

    private static boolean isSUB(int opcode) {
        return Arrays.asList(100, 101, 103, 102).contains(opcode);
    }

    private static boolean isMUL(int opcode) {
        return Arrays.asList(104, 105, 107, 106).contains(opcode);
    }

    private static boolean isDIV(int opcode) {
        return Arrays.asList(108, 109, 111, 110).contains(opcode);
    }

    private static boolean isNEG(int opcode) {
        return Arrays.asList(116, 117, 119, 118).contains(opcode);
    }

    private static boolean isXRETURN(int opcode) {
        return Arrays.asList(172, 175, 174, 176).contains(opcode);
    }

    private static boolean isPUSH(int opcode) {
        return Arrays.asList(16, 17).contains(opcode);
    }

    private static boolean isNO_ACTION(int opcode) {
        return Arrays.asList(87, 171, 170, 183, 179, 181, 167, 89, 187, 177, 191, 133, 147, 134, 135, 145, 145, 138, 137, 136, 141, 139, 140, Jutil.LABEL_OPCODE, Jutil.BEGIN_METHOD_OPCODE).contains(opcode);
    }

    private Function<ExprNode, ExprNode> concoleStepAction(LoggerState currentState, Optional<LoggerState> previousState) {
        boolean jumpFollowed = Concoler.isJumpFollowed(currentState, previousState);
        int opcode = currentState.getOpcode();
        if (Concoler.isLOAD(opcode)) {
            return Concoler.ILOAD(currentState);
        }
        if (Concoler.isSTORE(opcode)) {
            return Concoler.ISTORE(currentState);
        }
        if (Concoler.isADD(opcode)) {
            return this.IADD();
        }
        if (Concoler.isSUB(opcode)) {
            return this.ISUB();
        }
        if (Concoler.isMUL(opcode)) {
            return this.IMUL();
        }
        if (Concoler.isDIV(opcode)) {
            return this.IDIV();
        }
        if (Concoler.isNEG(opcode)) {
            return Concoler.NO_ACTION();
        }
        if (opcode == 1) {
            return Concoler.NULLPUSH();
        }
        if (opcode == 2) {
            return this.INTEGERPUSH(-1);
        }
        if (opcode == 3) {
            return this.INTEGERPUSH(0);
        }
        if (opcode == 4) {
            return this.INTEGERPUSH(1);
        }
        if (opcode == 5) {
            return this.INTEGERPUSH(2);
        }
        if (opcode == 6) {
            return this.INTEGERPUSH(3);
        }
        if (opcode == 7) {
            return this.INTEGERPUSH(4);
        }
        if (opcode == 8) {
            return this.INTEGERPUSH(5);
        }
        if (opcode == 9) {
            return this.INTEGERPUSH(0);
        }
        if (opcode == 10) {
            return this.INTEGERPUSH(1);
        }
        if (opcode == 11) {
            return this.INTEGERPUSH(0);
        }
        if (opcode == 12) {
            return this.INTEGERPUSH(1);
        }
        if (opcode == 13) {
            return this.INTEGERPUSH(2);
        }
        if (opcode == 14) {
            return this.INTEGERPUSH(0);
        }
        if (opcode == 15) {
            return this.INTEGERPUSH(1);
        }
        if (Concoler.isPUSH(opcode)) {
            return this.INTEGERPUSH((Integer)currentState.getOperand());
        }
        if (Concoler.isCMP(opcode)) {
            return Jutil.applyRecursively(cmp);
        }
        if (opcode == 154) {
            return this.IFNE(jumpFollowed);
        }
        if (opcode == 153) {
            return this.IFNE(!jumpFollowed);
        }
        if (opcode == 156) {
            return this.IFGE(jumpFollowed);
        }
        if (opcode == 157) {
            return this.IFGT(jumpFollowed);
        }
        if (opcode == 158) {
            return this.IFLE(jumpFollowed);
        }
        if (opcode == 155) {
            return this.IFLT(jumpFollowed);
        }
        if (opcode == 166) {
            return this.IF_ICMPEQ(jumpFollowed);
        }
        if (opcode == 165) {
            return this.IF_ICMPEQ(jumpFollowed);
        }
        if (opcode == 160) {
            return this.IF_ICMPNE(jumpFollowed);
        }
        if (opcode == 159) {
            return this.IF_ICMPEQ(jumpFollowed);
        }
        if (opcode == 162) {
            return this.IF_ICMPGE(jumpFollowed);
        }
        if (opcode == 163) {
            return this.IF_ICMPGT(jumpFollowed);
        }
        if (opcode == 164) {
            return this.IF_ICMPLE(jumpFollowed);
        }
        if (opcode == 161) {
            return this.IF_ICMPLT(jumpFollowed);
        }
        if (opcode == 198) {
            return this.IFNULL(jumpFollowed);
        }
        if (opcode == 199) {
            return this.IFNONNULL(jumpFollowed);
        }
        if (opcode == 182) {
            return Concoler.createInvokeMethodFunction(currentState, previousState, true);
        }
        if (opcode == 184) {
            return Concoler.createInvokeMethodFunction(currentState, previousState, false);
        }
        if (opcode == 185) {
            return Concoler.createInvokeMethodFunction(currentState, previousState, true);
        }
        if (opcode == 178) {
            return Concoler.ILOAD(Concoler.nonMatchingState());
        }
        if (opcode == 180) {
            return this.GETFIELD(currentState);
        }
        if (opcode == 18) {
            return this.LDC(currentState);
        }
        if (Concoler.isXRETURN(opcode)) {
            return Concoler.GENERAL_RETURN(previousState);
        }
        if (opcode == 193) {
            return this.INSTANCEOF(currentState);
        }
        if (opcode == 192) {
            return this.CHECKCAST(currentState);
        }
        if (Concoler.isNO_ACTION(opcode)) {
            return Concoler.NO_ACTION();
        }
        return Concoler.NO_ACTION();
    }

    private Function<ExprNode, ExprNode> CHECKCAST(LoggerState currentState) {
        StackNode stackTop = new StackNode(0);
        InstanceOfNode instanceOfNode = new InstanceOfNode(stackTop, ((String)currentState.getOperand()).replace("/", "."));
        NotEqualNode instanceOfEq = new NotEqualNode(Arrays.asList(new IntNode(0), instanceOfNode));
        return this.AND(instanceOfEq);
    }

    private Function<ExprNode, ExprNode> INSTANCEOF(LoggerState currentState) {
        String instanceType = (String)currentState.getOperand();
        return Jutil.applyRecursively(Jutil.curry(instanceOf, instanceType));
    }

    private Function<ExprNode, ExprNode> LDC(LoggerState currentState) {
        if (currentState.getOperand() instanceof Integer) {
            return this.INTEGERPUSH((Integer)currentState.getOperand());
        }
        if (currentState.getOperand() instanceof Long) {
            return this.INTEGERPUSH(new BigDecimal((Long)currentState.getOperand()).intValue());
        }
        if (currentState.getOperand() instanceof String) {
            return this.INTEGERPUSH(99999);
        }
        return Concoler.NO_ACTION();
    }

    private Function<ExprNode, ExprNode> GETFIELD(LoggerState currentState) {
        List ids = (List)currentState.getOperand();
        GetFieldNode getFieldNode = new GetFieldNode(new StackNode(0), (String)ids.get(0), (String)ids.get(2), currentState.getReturnValue());
        return Jutil.applyRecursively(Jutil.curry(getfield, getFieldNode));
    }

    private Function<ExprNode, ExprNode> IFNONNULL(boolean jumpFollowed) {
        if (jumpFollowed) {
            return Concoler.NO_ACTION();
        }
        ExprNode condition = UtilEquation.stackTopNull();
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFNULL(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopNull();
            return this.AND(condition);
        }
        return Concoler.NO_ACTION();
    }

    private Function<ExprNode, ExprNode> IF_ICMPLT(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(LessThanNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(GreaterThanEqNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IF_ICMPLE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(LessThanEqNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(GreaterThanNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IF_ICMPGT(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(GreaterThanEqNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(LessThanNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IF_ICMPGE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(GreaterThanNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(LessThanEqNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IF_ICMPNE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(NotEqualNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(EqualNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IF_ICMPEQ(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopsCondition(EqualNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopsCondition(NotEqualNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFLT(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopConditionZero(LessThanNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopConditionZero(GreaterThanEqNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFLE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopConditionZero(LessThanEqNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopConditionZero(GreaterThanNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFGT(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopConditionZero(GreaterThanNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopConditionZero(LessThanEqNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFGE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopConditionZero(GreaterThanEqNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopConditionZero(LessThanNode.class);
        return this.AND(condition);
    }

    private Function<ExprNode, ExprNode> IFNE(boolean jumpFollowed) {
        if (jumpFollowed) {
            ExprNode condition = UtilEquation.stackTopConditionZero(NotEqualNode.class);
            return this.AND(condition);
        }
        ExprNode condition = UtilEquation.stackTopConditionZero(EqualNode.class);
        return this.AND(condition);
    }

    private static boolean isCMP(int opcode) {
        return opcode == 148 || opcode == 151 || opcode == 152 || opcode == 149 || opcode == 150;
    }

    private static boolean isSubroutineLogged(Optional<LoggerState> previousState) {
        if (previousState.isPresent()) {
            return previousState.get().getOpcode() == Jutil.BEGIN_METHOD_OPCODE;
        }
        return false;
    }

    public static boolean isJumpFollowed(LoggerState currentState, Optional<LoggerState> nextState) {
        if (!nextState.isPresent()) {
            return false;
        }
        if (currentState.getOperand() == null) {
            return false;
        }
        if (nextState.get().getOperand() == null) {
            return false;
        }
        String jumpLabel = currentState.getOperand().toString();
        String prevLabel = nextState.get().getOperand().toString();
        return jumpLabel.equals(prevLabel);
    }

    private static Function<ExprNode, ExprNode> NO_ACTION() {
        return e -> e;
    }

    private static Function<ExprNode, ExprNode> NULLPUSH() {
        return Jutil.applyRecursively(Concoler.nullpushTransformation());
    }

    private static Function<ExprNode, ExprNode> nullpushTransformation() {
        return node -> {
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return new NullNode();
                }
                return new StackNode(locationOnStack - 1);
            }
            return node;
        };
    }

    private static Function<ExprNode, ExprNode> GENERAL_RETURN(Optional<LoggerState> previousState) {
        if (previousState.isPresent()) {
            return Concoler.ISTORE(Concoler.nonMatchingState());
        }
        return Concoler.NO_ACTION();
    }

    private static Function<ExprNode, ExprNode> createInvokeMethodFunction(LoggerState currentState, Optional<LoggerState> previousState, boolean hasInstance) {
        boolean subRoutineLogged = Concoler.isSubroutineLogged(previousState);
        String[] myMethodIdentifier = ((String)currentState.getOperand()).split("\\|");
        String classPackage = myMethodIdentifier[0];
        String methodName = myMethodIdentifier[1];
        String methodDesc = myMethodIdentifier[2];
        int numberofLocalParameters = Jutil.descToParameterTypes(methodDesc).length;
        if (hasInstance) {
            ++numberofLocalParameters;
        }
        List<ExprNode> children = IntStream.range(0, numberofLocalParameters).mapToObj(p -> new StackNode(p)).collect(Collectors.toList());
        InvokeVirtualNode invokeVirtualNode = new InvokeVirtualNode(children, classPackage, methodName, methodDesc, currentState.returnValue);
        return Jutil.applyRecursively(Jutil.curry(Concoler.invokeVirtual(subRoutineLogged), invokeVirtualNode));
    }

    private static LoggerState nonMatchingState() {
        return new LoggerState(0, new Integer(50));
    }

    private static Function<ExprNode, ExprNode> ILOAD(LoggerState state) {
        return node -> {
            Function<ExprNode, ExprNode> iloadTransformation = Concoler.iloadTransformation(state);
            return Jutil.applyRecursively(iloadTransformation).apply((ExprNode)node);
        };
    }

    private static Function<ExprNode, ExprNode> iloadTransformation(LoggerState state) {
        return node -> {
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return new LocalNode((Integer)state.getOperand());
                }
                return new StackNode(locationOnStack - 1);
            }
            return node;
        };
    }

    private static Function<ExprNode, ExprNode> ISTORE(LoggerState state) {
        return node -> {
            Function<ExprNode, ExprNode> istoreTransformation = Concoler.istoreTransformation(state);
            return Jutil.applyRecursively(istoreTransformation).apply((ExprNode)node);
        };
    }

    private static Function<ExprNode, ExprNode> istoreTransformation(LoggerState state) {
        return node -> {
            if (node instanceof LocalNode) {
                int locationOnLocal = ((LocalNode)node).getValue();
                if (locationOnLocal == (Integer)state.getOperand()) {
                    return new StackNode(0);
                }
                return node;
            }
            if (node instanceof StackNode) {
                return new StackNode(((StackNode)node).getValue() + 1);
            }
            return node;
        };
    }

    private Function<ExprNode, ExprNode> IADD() {
        return node -> Jutil.applyRecursively(this.arithmeticTransformation(AddNode.class)).apply((ExprNode)node);
    }

    private Function<ExprNode, ExprNode> ISUB() {
        return node -> Jutil.applyRecursively(this.isubTransformation()).apply((ExprNode)node);
    }

    private Function<ExprNode, ExprNode> isubTransformation() {
        return node -> {
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return new AddNode(Arrays.asList(new MinusNode(new StackNode(0)), new StackNode(1)));
                }
                return new StackNode(locationOnStack + 1);
            }
            return node;
        };
    }

    private Function<ExprNode, ExprNode> IMUL() {
        return node -> Jutil.applyRecursively(this.arithmeticTransformation(MultiplicationNode.class)).apply((ExprNode)node);
    }

    private Function<ExprNode, ExprNode> IDIV() {
        return node -> Jutil.applyRecursively(this.arithmeticTransformation(DivisionNode.class)).apply((ExprNode)node);
    }

    private Function<ExprNode, ExprNode> arithmeticTransformation(Class nodeClass) {
        return node -> {
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return Jutil.createNode.apply(nodeClass, Arrays.asList(new StackNode(0), new StackNode(1)));
                }
                return new StackNode(locationOnStack + 1);
            }
            return node;
        };
    }

    private Function<ExprNode, ExprNode> INTEGERPUSH(int pushed) {
        return node -> Jutil.applyRecursively(this.integerpushTransformation(pushed)).apply((ExprNode)node);
    }

    private Function<ExprNode, ExprNode> integerpushTransformation(Integer pushed) {
        return node -> {
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return new IntNode(pushed);
                }
                return new StackNode(locationOnStack - 1);
            }
            return node;
        };
    }

    public static BiFunction<ExprNode, ExprNode, ExprNode> invokeVirtual(boolean subroutineLogged) {
        return (node, invokeVirtualNode) -> {
            int incrementStacks = invokeVirtualNode.getChildren().size() - 1;
            if (node instanceof StackNode) {
                int locationOnStack = ((StackNode)node).getValue();
                if (locationOnStack == 0) {
                    return invokeVirtualNode;
                }
                return new StackNode(locationOnStack + incrementStacks);
            }
            if (subroutineLogged && node instanceof LocalNode) {
                int virtualNodeParams;
                int location = ((LocalNode)node).getValue();
                if (location <= (virtualNodeParams = invokeVirtualNode.getChildren().size() - 1)) {
                    return new StackNode(virtualNodeParams - location);
                }
                return node;
            }
            return node;
        };
    }

    private Function<ExprNode, ExprNode> AND(ExprNode condition) {
        return node -> new AndNode(Arrays.asList(condition, node));
    }
}

