/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.LoggerState;

public class ExecutionPath {
    private final ArrayList<LoggerState> states;

    public ExecutionPath(List<LoggerState> states) {
        this.states = new ArrayList<LoggerState>(states);
    }

    public List<LoggerState> getStates() {
        return this.states;
    }

    public List<String> getLabels() {
        return this.getStates().stream().filter(s -> s.getOpcode() == Jutil.LABEL_OPCODE).map(s -> (String)s.getOperand()).collect(Collectors.toList());
    }

    public ExecutionPath stripBeforeBEGINMETHOD(String methodInfo) {
        ArrayList<LoggerState> methodStates = new ArrayList<LoggerState>();
        boolean methodFound = false;
        for (int i = 0; i < this.states.size(); ++i) {
            if (methodFound) {
                methodStates.add(this.states.get(i));
            }
            if (this.states.get(i).getOpcode() != Jutil.BEGIN_METHOD_OPCODE || !this.states.get(i).getOperand().equals(methodInfo)) continue;
            methodFound = true;
        }
        return new ExecutionPath(methodStates);
    }

    public ExecutionPath removeSubroutineStates(List<String> methodLabels) {
        String label;
        ArrayList<LoggerState> methodStates = new ArrayList<LoggerState>();
        boolean insideMethod = false;
        int subCall = -1;
        for (LoggerState state : this.states) {
            if (state.getOpcode() == Jutil.LABEL_OPCODE) {
                label = (String)state.getOperand();
                if (methodLabels.contains(label)) {
                    insideMethod = true;
                    subCall = 0;
                } else if (insideMethod) {
                    insideMethod = false;
                    subCall = 1;
                }
            }
            if (insideMethod) {
                if (state.getOpcode() <= Jutil.BEGIN_METHOD_OPCODE) continue;
                methodStates.add(state);
                continue;
            }
            if (!ExecutionPath.isReturnOpcode(state.getOpcode()) || subCall <= 0) continue;
            --subCall;
            insideMethod = true;
        }
        for (LoggerState state : methodStates) {
            if (state.getOpcode() != Jutil.LABEL_OPCODE || methodLabels.contains(label = (String)state.getOperand())) continue;
            throw new RuntimeException("Cannot remove subroutine path");
        }
        return new ExecutionPath(methodStates);
    }

    public static boolean isReturnOpcode(int opcode) {
        return opcode == 176 || opcode == 172 || opcode == 177 || opcode == 173 || opcode == 175 || opcode == 174;
    }
}

