/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tsers.junitquest.CallParam;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.Solver;
import org.tsers.junitquest.expr.AndNode;
import org.tsers.junitquest.expr.EqualNode;
import org.tsers.junitquest.expr.ExprNode;
import org.tsers.junitquest.expr.InstanceOfNode;
import org.tsers.junitquest.expr.IntNode;
import org.tsers.junitquest.expr.LocalNode;
import org.tsers.junitquest.expr.NotEqualNode;

public class InitialExpression {
    private static List<CallParam> initialCallparams;

    private static boolean is32bitPrimite(String s) {
        return Arrays.asList("int", "char", "float", "short", "byte", "boolean").contains(s);
    }

    private static boolean is64bitPrimitive(String s) {
        return Arrays.asList("long", "double").contains(s);
    }

    private static boolean isInterface(String s) {
        return s.split(" ")[0].equals("interface");
    }

    private static boolean isClass(String s) {
        return s.split(" ")[0].equals("class");
    }

    public static ExprNode createInitialExpression(AccessibleObject method) {
        Class[] paramTypes = Jutil.getParameterTypes(method);
        ArrayList<ExprNode> equalsExpressions = new ArrayList<ExprNode>();
        int prefixForVirtualCalls = InitialExpression.getPrefix(method);
        if (prefixForVirtualCalls == 1) {
            ExprNode virtualMethodInstanceExpr = InitialExpression.createInstanceOfExpression(0, Jutil.getDeclaringClass(method).getName());
            equalsExpressions.add(virtualMethodInstanceExpr);
        }
        int prefixFor64BitPrimitives = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            int localIndex = i + prefixForVirtualCalls + prefixFor64BitPrimitives;
            String paramType = ((Object)paramTypes[i]).toString();
            if (InitialExpression.is32bitPrimite(paramType)) {
                equalsExpressions.add(InitialExpression.createIntNodeExpression(localIndex));
                continue;
            }
            if (InitialExpression.is64bitPrimitive(paramType)) {
                equalsExpressions.add(InitialExpression.createIntNodeExpression(localIndex));
                ++prefixFor64BitPrimitives;
                continue;
            }
            if (InitialExpression.isInterface(paramType) || InitialExpression.isClass(paramType)) {
                String instanceName = paramType.split(" ")[1];
                equalsExpressions.add(InitialExpression.createInstanceOfExpression(localIndex, instanceName));
                continue;
            }
            throw new RuntimeException("Cannot create initial expression, unknown type:" + paramType);
        }
        AndNode initialExpresssion = new AndNode(equalsExpressions);
        initialCallparams = Solver.solve(initialExpresssion).get(0);
        return initialExpresssion;
    }

    private static ExprNode createInstanceOfExpression(int localIndex, String instanceName) {
        LocalNode local = new LocalNode(localIndex);
        InstanceOfNode instanceOfNode = new InstanceOfNode(local, instanceName);
        return new NotEqualNode(Arrays.asList(new IntNode(0), instanceOfNode));
    }

    private static ExprNode createIntNodeExpression(int localIndex) {
        LocalNode local = new LocalNode(localIndex);
        IntNode constant = new IntNode(0);
        return new EqualNode(Arrays.asList(local, constant));
    }

    private static int getPrefix(AccessibleObject method) {
        if (Jutil.isStatic(method)) {
            return 0;
        }
        return 1;
    }

    public static List<CallParam> getInitialCallParams() {
        return initialCallparams;
    }
}

