/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tsers.junitquest.Concoler;
import org.tsers.junitquest.ConcolerInput;
import org.tsers.junitquest.ExecutionPath;
import org.tsers.junitquest.LoggerState;
import org.tsers.junitquest.UtilEquation;
import org.tsers.junitquest.expr.AndNode;
import org.tsers.junitquest.expr.EqualNode;
import org.tsers.junitquest.expr.ExprNode;
import org.tsers.junitquest.expr.GreaterThanEqNode;
import org.tsers.junitquest.expr.GreaterThanNode;
import org.tsers.junitquest.expr.InstanceOfNode;
import org.tsers.junitquest.expr.IntNode;
import org.tsers.junitquest.expr.LessThanEqNode;
import org.tsers.junitquest.expr.LessThanNode;
import org.tsers.junitquest.expr.NotEqualNode;
import org.tsers.junitquest.expr.StackNode;

public class InputCreator {
    public static List<Integer> BRANCH_INSTRUCTIONS = Arrays.asList(165, 166, 159, 162, 163, 164, 161, 160, 153, 156, 157, 158, 155, 154, 199, 198, 171, 170, 192);

    public static ArrayList<ConcolerInput> createConcolerInputs(ExecutionPath givenPath) {
        ArrayList<ConcolerInput> concolerInputs = new ArrayList<ConcolerInput>();
        ArrayList<LoggerState> seenStates = new ArrayList<LoggerState>();
        for (int i = 0; i < givenPath.getStates().size(); ++i) {
            LoggerState currentState = givenPath.getStates().get(i);
            Optional<LoggerState> nextState = Concoler.getNextState(givenPath.getStates(), i);
            boolean isJumpFollowed = Concoler.isJumpFollowed(currentState, nextState);
            concolerInputs.addAll(InputCreator.opcodeToConcolerInput(seenStates, currentState, isJumpFollowed));
            seenStates.add(currentState);
        }
        return concolerInputs;
    }

    private static List<ConcolerInput> opcodeToConcolerInput(List<LoggerState> seenStates, LoggerState currentState, boolean isJumpFollowed) {
        if (!BRANCH_INSTRUCTIONS.contains(currentState.getOpcode())) {
            return Arrays.asList(new ConcolerInput[0]);
        }
        if (currentState.getOpcode() == 192) {
            StackNode stackTop = new StackNode(0);
            InstanceOfNode instanceOfNode = new InstanceOfNode(stackTop, ((String)currentState.getOperand()).replace("/", "."));
            NotEqualNode instanceOfEq = new NotEqualNode(Arrays.asList(new IntNode(0), instanceOfNode));
            return Arrays.asList(new ConcolerInput(new ExecutionPath(seenStates), instanceOfEq));
        }
        return InputCreator.branchOpcodeToConcolerInput(seenStates, currentState, isJumpFollowed);
    }

    private static List<ConcolerInput> branchOpcodeToConcolerInput(List<LoggerState> seenStates, LoggerState state, boolean isJumpFollowed) {
        int opcode = state.getOpcode();
        if (opcode == 154) {
            return InputCreator.IFNEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 153) {
            return InputCreator.IFEQConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 156) {
            return InputCreator.IFGEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 157) {
            return InputCreator.IFGTConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 158) {
            return InputCreator.IFLEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 155) {
            return InputCreator.IFLTConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 159) {
            return InputCreator.IF_ICMPEQConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 160) {
            return InputCreator.IF_ICMPNEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 162) {
            return InputCreator.IF_ICMPGEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 163) {
            return InputCreator.IF_ICMPGTConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 164) {
            return InputCreator.IF_ICMPLEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 161) {
            return InputCreator.ICMPLTConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 166) {
            return InputCreator.IF_ICMPNEConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 171) {
            return InputCreator.LOOKUPSWITCHConditions(seenStates, state);
        }
        if (opcode == 170) {
            return InputCreator.TABLESWITCHConditions(seenStates, state);
        }
        if (opcode == 199) {
            return InputCreator.IFNONNULLConditions(seenStates, isJumpFollowed);
        }
        if (opcode == 198) {
            return InputCreator.IFNULLConditions(seenStates, isJumpFollowed);
        }
        return Arrays.asList(new ConcolerInput[0]);
    }

    private static List<ConcolerInput> IFNULLConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(new ConcolerInput[0]);
        }
        return Arrays.asList(InputCreator.stackTopNull(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFNONNULLConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopNull(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(new ConcolerInput[0]);
    }

    private static List<ConcolerInput> TABLESWITCHConditions(List<LoggerState> seenStates, LoggerState state) {
        Integer min = (Integer)((List)state.getOperand()).get(0);
        Integer max = (Integer)((List)state.getOperand()).get(1);
        return IntStream.range(min, max + 2).mapToObj(c -> {
            StackNode stackNode0 = new StackNode(0);
            IntNode intNode = new IntNode(c);
            EqualNode equalNode = new EqualNode(Arrays.asList(stackNode0, intNode));
            return new ConcolerInput(new ExecutionPath(seenStates), equalNode);
        }).collect(Collectors.toList());
    }

    private static List<ConcolerInput> LOOKUPSWITCHConditions(List<LoggerState> seenStates, LoggerState state) {
        ArrayList<ConcolerInput> createdInputs = new ArrayList<ConcolerInput>();
        List keys = (List)((List)state.getOperand()).get(0);
        ArrayList<ExprNode> notEquals = new ArrayList<ExprNode>();
        for (Integer key : keys) {
            StackNode stackNode0 = new StackNode(0);
            IntNode constantNode = new IntNode(key);
            EqualNode equalNode = new EqualNode(Arrays.asList(stackNode0, constantNode));
            createdInputs.add(new ConcolerInput(new ExecutionPath(seenStates), equalNode));
            NotEqualNode notEqualNode = new NotEqualNode(Arrays.asList(stackNode0, constantNode));
            notEquals.add(notEqualNode);
        }
        createdInputs.add(new ConcolerInput(new ExecutionPath(seenStates), new AndNode(notEquals)));
        return createdInputs;
    }

    private static List<ConcolerInput> ICMPLTConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsCondition(GreaterThanEqNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsCondition(LessThanNode.class, new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IF_ICMPLEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsCondition(GreaterThanNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsCondition(LessThanEqNode.class, new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IF_ICMPGTConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsCondition(LessThanEqNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsCondition(GreaterThanNode.class, new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IF_ICMPGEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsCondition(LessThanNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsCondition(GreaterThanEqNode.class, new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IF_ICMPNEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsEqual(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsNotEqual(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IF_ICMPEQConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopsNotEqual(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopsEqual(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFLTConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(GreaterThanEqNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsOne(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(LessThanNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsMinusOne(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFLEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(GreaterThanNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsOne(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(LessThanEqNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsMinusOne(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFGTConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(LessThanEqNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsMinusOne(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(GreaterThanNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsOne(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFGEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(LessThanNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsMinusOne(new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(GreaterThanEqNode.class, new ExecutionPath(seenStates)), InputCreator.stackTopEqualsOne(new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFEQConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(NotEqualNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(EqualNode.class, new ExecutionPath(seenStates)));
    }

    private static List<ConcolerInput> IFNEConditions(List<LoggerState> seenStates, boolean isJumpFollowed) {
        if (isJumpFollowed) {
            return Arrays.asList(InputCreator.stackTopConditionZero(EqualNode.class, new ExecutionPath(seenStates)));
        }
        return Arrays.asList(InputCreator.stackTopConditionZero(NotEqualNode.class, new ExecutionPath(seenStates)));
    }

    private static ConcolerInput stackTopEqualsOne(ExecutionPath seenExecutionPath) {
        ExprNode conditionNode = UtilEquation.stackTopEqualsOne();
        return new ConcolerInput(seenExecutionPath, conditionNode);
    }

    private static ConcolerInput stackTopEqualsMinusOne(ExecutionPath seenExecutionPath) {
        ExprNode conditionNode = UtilEquation.stackTopEqualsMinusOne();
        return new ConcolerInput(seenExecutionPath, conditionNode);
    }

    private static ConcolerInput stackTopConditionZero(Class nodeConditionClass, ExecutionPath seenExecutionPath) {
        ExprNode conditionNode = UtilEquation.stackTopConditionZero(nodeConditionClass);
        return new ConcolerInput(seenExecutionPath, conditionNode);
    }

    private static ConcolerInput stackTopsCondition(Class nodeConditionClass, ExecutionPath seenExecutionPath) {
        ExprNode conditionNode = UtilEquation.stackTopsCondition(nodeConditionClass);
        return new ConcolerInput(seenExecutionPath, conditionNode);
    }

    private static ConcolerInput stackTopNull(ExecutionPath seenExecutionPath) {
        ExprNode equalNode = UtilEquation.stackTopNull();
        return new ConcolerInput(seenExecutionPath, equalNode);
    }

    private static ConcolerInput stackTopsNotEqual(ExecutionPath seenExecutionPath) {
        ExprNode equalNode = UtilEquation.stackTopsCondition(NotEqualNode.class);
        return new ConcolerInput(seenExecutionPath, equalNode);
    }

    private static ConcolerInput stackTopsEqual(ExecutionPath seenExecutionPath) {
        ExprNode equalNode = UtilEquation.stackTopsCondition(EqualNode.class);
        return new ConcolerInput(seenExecutionPath, equalNode);
    }
}

