/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.tsers.junitquest.InstanceHelper;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.finder.MyClassWriter;

public class Instrumenter {
    private static Map<String, Class> instrumentedClasses = new HashMap<String, Class>();
    private static List<MethodNode> methodNodes = new ArrayList<MethodNode>();
    private static URLClassLoader urlClassLoader;
    private static String LOGGER_LOCATION;

    public static Class getClass(String packagename) {
        try {
            if (instrumentedClasses.containsKey(packagename)) {
                return instrumentedClasses.get(packagename);
            }
            return urlClassLoader.loadClass(packagename);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class: " + packagename);
        }
    }

    public static void instrumentClasses(List<String> packagenames, String bytecodeLocation) {
        ClassLoader sysloader = ClassLoader.getSystemClassLoader();
        Instrumenter.instrumentClasses(packagenames, bytecodeLocation, sysloader);
    }

    private static String getByteCodeLocation(String byteCodeLocation) {
        if (!byteCodeLocation.endsWith(Character.toString(File.separatorChar))) {
            return byteCodeLocation + File.separatorChar;
        }
        return byteCodeLocation;
    }

    public static void instrumentClasses(List<String> packagenames, String rawBytecodeLocation, ClassLoader classLoader) {
        try {
            String bytecodeLocation = Instrumenter.getByteCodeLocation(rawBytecodeLocation);
            instrumentedClasses = new HashMap<String, Class>();
            methodNodes = new ArrayList<MethodNode>();
            String byteCodeFolder = "file://" + bytecodeLocation;
            URL[] classLoaderUrls = new URL[]{new URL(byteCodeFolder)};
            urlClassLoader = new URLClassLoader(classLoaderUrls, classLoader);
            Class[] parameters = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE};
            Method classLoaderMethod = ClassLoader.class.getDeclaredMethod("defineClass", parameters);
            classLoaderMethod.setAccessible(true);
            for (String packagename : packagenames) {
                FileInputStream stream = new FileInputStream(bytecodeLocation + packagename.replace(".", "/") + ".class");
                byte[] instrumentedByteCode = Instrumenter.getInstrumentedByteCode(stream);
                Class instrumentedClass = (Class)classLoaderMethod.invoke((Object)urlClassLoader, packagename, instrumentedByteCode, 0, instrumentedByteCode.length);
                instrumentedClasses.put(packagename, instrumentedClass);
            }
            InstanceHelper.setClassLoader(urlClassLoader);
            InstanceHelper.init(urlClassLoader, bytecodeLocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<MethodNode> getMethodNodes() {
        return methodNodes;
    }

    public static MethodNode getMethodNode(String packagename, String methodName, String methodDesc) {
        MethodNode node = Instrumenter.getMethodNodes().stream().filter(m -> m.name.equals(methodName) && m.desc.equals(methodDesc)).findAny().orElseThrow(() -> new RuntimeException("Cannot find methodnode for: " + methodName));
        return node;
    }

    private static byte[] getInstrumentedByteCode(InputStream classStream) throws IOException {
        ClassReader classReader = new ClassReader(classStream);
        ClassNode classNode = new ClassNode();
        classReader.accept(classNode, 0);
        methodNodes.addAll(classNode.methods);
        classNode.methods.stream().forEach(m -> Instrumenter.instrumentMethod(m));
        MyClassWriter classWriter = new MyClassWriter(3, urlClassLoader);
        classNode.accept(classWriter);
        return classWriter.toByteArray();
    }

    private static void instrumentMethod(MethodNode methodNode) {
        if (methodNode.instructions.size() == 0) {
            return;
        }
        String methodInfo = methodNode.name + " " + methodNode.desc;
        InsnList instructions = methodNode.instructions;
        List<AbstractInsnNode> originalInstructions = Arrays.asList(instructions.toArray());
        for (AbstractInsnNode current : originalInstructions) {
            int index = originalInstructions.indexOf(current);
            if (current instanceof LabelNode) {
                instructions.insert(current, Instrumenter.createLoggingInjection(current, index));
                continue;
            }
            instructions.insertBefore(current, Instrumenter.createLoggingInjection(current, index));
            instructions.insert(current, Instrumenter.createLogMethodReturnValue(current, index));
        }
        instructions.insertBefore(instructions.get(0), Instrumenter.createMethodBeginInjection(methodInfo));
    }

    private static InsnList createMethodBeginInjection(String methodDesc) {
        InsnList instructionList = new InsnList();
        instructionList.add(new LdcInsnNode(methodDesc));
        instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logBEGINMETHOD", "(Ljava/lang/String;)V"));
        return instructionList;
    }

    public static InsnList createLogMethodReturnValue(AbstractInsnNode current, int methodIdentifierIndex) {
        InsnList instructionList = new InsnList();
        if (current instanceof MethodInsnNode) {
            if (Jutil.methodReturnsInt(((MethodInsnNode)current).desc)) {
                instructionList.add(Instrumenter.createLogStackTopInjection(methodIdentifierIndex));
            }
        } else if (current.getOpcode() == 180 && Jutil.fieldReturnsInt(((FieldInsnNode)current).desc)) {
            instructionList.add(Instrumenter.createLogStackTopInjection(methodIdentifierIndex));
        }
        return instructionList;
    }

    private static InsnList createLogStackTopInjection(int methodIdentifierIndex) {
        InsnList instructionList = new InsnList();
        instructionList.add(new InsnNode(89));
        instructionList.add(new IntInsnNode(16, methodIdentifierIndex));
        instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logStackTop", "(II)V"));
        return instructionList;
    }

    private static InsnList createLoggingInjection(AbstractInsnNode current, int methodIndentifierIndex) {
        InsnList instructionList = new InsnList();
        if (current instanceof FrameNode) {
            return instructionList;
        }
        if (current.getOpcode() == 21) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logILOAD", "(I)V"));
        } else if (current.getOpcode() == 22) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLLOAD", "(I)V"));
        } else if (current.getOpcode() == 1) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logACONST_NULL", "()V"));
        } else if (current.getOpcode() == 2) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_M1", "()V"));
        } else if (current.getOpcode() == 3) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_0", "()V"));
        } else if (current.getOpcode() == 4) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_1", "()V"));
        } else if (current.getOpcode() == 5) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_2", "()V"));
        } else if (current.getOpcode() == 6) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_3", "()V"));
        } else if (current.getOpcode() == 7) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_4", "()V"));
        } else if (current.getOpcode() == 8) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logICONST_5", "()V"));
        } else if (current.getOpcode() == 9) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLCONST_0", "()V"));
        } else if (current.getOpcode() == 10) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLCONST_1", "()V"));
        } else if (current.getOpcode() == 16) {
            instructionList.add(new IntInsnNode(16, ((IntInsnNode)current).operand));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logBIPUSH", "(I)V"));
        } else if (current.getOpcode() == 17) {
            instructionList.add(new IntInsnNode(17, ((IntInsnNode)current).operand));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logSIPUSH", "(I)V"));
        } else if (current.getOpcode() == 96) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIADD", "()V"));
        } else if (current.getOpcode() == 97) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLADD", "()V"));
        } else if (current.getOpcode() == 100) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logISUB", "()V"));
        } else if (current.getOpcode() == 101) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLSUB", "()V"));
        } else if (current.getOpcode() == 108) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIDIV", "()V"));
        } else if (current.getOpcode() == 104) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIMUL", "()V"));
        } else if (current.getOpcode() == 112) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIREM", "()V"));
        } else if (current.getOpcode() == 116) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logINEG", "()V"));
        } else if (current.getOpcode() == 117) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLNEG", "()V"));
        } else if (current.getOpcode() == 105) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLMUL", "()V"));
        } else if (current.getOpcode() == 109) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDIV", "()V"));
        } else if (current.getOpcode() == 148) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLCMP", "()V"));
        } else if (current.getOpcode() == 54) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logISTORE", "(I)V"));
        } else if (current.getOpcode() == 55) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLSTORE", "(I)V"));
        } else if (current.getOpcode() == 154) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFNE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 158) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFLE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 156) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFGE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 157) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFGT", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 155) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFLT", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 160) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPNE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 162) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPGE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 163) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPGT", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 164) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPLE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 161) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPLT", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 159) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ICMPEQ", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 166) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ACMPNE", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 165) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIF_ACMPEQ", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 167) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logGOTO", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 177) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logRETURN", "()V"));
        } else if (current.getOpcode() == 172) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIRETURN", "()V"));
        } else if (current.getOpcode() == 176) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logARETURN", "()V"));
        } else if (current.getOpcode() == 173) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLRETURN", "()V"));
        } else if (current.getOpcode() == 178) {
            String s = ((FieldInsnNode)current).owner + ((FieldInsnNode)current).name + ((FieldInsnNode)current).desc;
            instructionList.add(new LdcInsnNode(s));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logGETSTATIC", "(Ljava/lang/Object;)V"));
        } else if (current.getOpcode() == 18) {
            LdcInsnNode lcdNode = (LdcInsnNode)current;
            if (lcdNode.cst instanceof Integer) {
                instructionList.add(new LdcInsnNode(lcdNode.cst));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(I)V"));
            } else if (lcdNode.cst instanceof Long) {
                instructionList.add(new LdcInsnNode(lcdNode.cst));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(J)V"));
            } else if (lcdNode.cst instanceof String) {
                instructionList.add(new LdcInsnNode(lcdNode.cst));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(Ljava/lang/String;)V"));
            } else if (lcdNode.cst instanceof Double) {
                instructionList.add(new LdcInsnNode((Object)((Double)lcdNode.cst).intValue()));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(I)V"));
            } else if (lcdNode.cst instanceof Float) {
                instructionList.add(new LdcInsnNode((Object)((Float)lcdNode.cst).intValue()));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(I)V"));
            } else if (lcdNode.cst instanceof Short) {
                instructionList.add(new LdcInsnNode((Object)((Short)lcdNode.cst).intValue()));
                instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLDC", "(I)V"));
            }
        } else if (current.getOpcode() == 182) {
            instructionList.add(Instrumenter.createLogInvokeMethodInstrumentation((MethodInsnNode)current, "logINVOKEVIRTUAL", methodIndentifierIndex));
        } else if (current.getOpcode() == 184) {
            instructionList.add(Instrumenter.createLogInvokeMethodInstrumentation((MethodInsnNode)current, "logINVOKESTATIC", methodIndentifierIndex));
        } else if (current.getOpcode() == 183) {
            instructionList.add(Instrumenter.createLogInvokeMethodInstrumentation((MethodInsnNode)current, "logINVOKESPECIAL", methodIndentifierIndex));
        } else if (current.getOpcode() == 185) {
            instructionList.add(Instrumenter.createLogInvokeMethodInstrumentation((MethodInsnNode)current, "logINVOKEINTERFACE", methodIndentifierIndex));
        } else if (current.getOpcode() == 171) {
            instructionList.add(Instrumenter.createLookupSwitchInstrumentation((LookupSwitchInsnNode)current));
        } else if (current.getOpcode() == 170) {
            instructionList.add(Instrumenter.createTableSwitchInstrumentation((TableSwitchInsnNode)current));
        } else if (current instanceof LabelNode) {
            instructionList.add(new LdcInsnNode(((LabelNode)current).getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLabel", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 187) {
            String desc = ((TypeInsnNode)current).desc;
            instructionList.add(new LdcInsnNode(desc));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logNEW", "(Ljava/lang/Object;)V"));
        } else if (current.getOpcode() == 188) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logNEWARRAY", "()V"));
        } else if (current.getOpcode() == 189) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logANEWARRAY", "()V"));
        } else if (current.getOpcode() == 87) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logPOP", "()V"));
        } else if (current.getOpcode() == 88) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logPOP2", "()V"));
        } else if (current.getOpcode() == 89) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDUP", "()V"));
        } else if (current.getOpcode() == 90) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDUP_X1", "()V"));
        } else if (current.getOpcode() == 83) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logAASTORE", "()V"));
        } else if (current.getOpcode() == 50) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logAALOAD", "()V"));
        } else if (current.getOpcode() == 58) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logASTORE", "(I)V"));
        } else if (current.getOpcode() == 25) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logALOAD", "(I)V"));
        } else if (current.getOpcode() == 46) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIALOAD", "()V"));
        } else if (current.getOpcode() == 79) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIASTORE", "()V"));
        } else if (current.getOpcode() == 51) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logBALOAD", "()V"));
        } else if (current.getOpcode() == 85) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logCASTORE", "()V"));
        } else if (current.getOpcode() == 52) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logCALOAD", "()V"));
        } else if (current.getOpcode() == 84) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logBASTORE", "()V"));
        } else if (current.getOpcode() == 126) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIAND", "()V"));
        } else if (current.getOpcode() == 128) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIOR", "()V"));
        } else if (current.getOpcode() == 130) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIXOR", "()V"));
        } else if (current.getOpcode() == 124) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIUSHR", "()V"));
        } else if (current.getOpcode() == 120) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logISHL", "()V"));
        } else if (current.getOpcode() == 193) {
            instructionList.add(new LdcInsnNode(((TypeInsnNode)current).desc));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logINSTANCEOF", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 153) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFEQ", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 192) {
            instructionList.add(new LdcInsnNode(((TypeInsnNode)current).desc));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logCHECKCAST", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 198) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFNULL", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 199) {
            instructionList.add(new LdcInsnNode(((JumpInsnNode)current).label.getLabel().toString()));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIFNONNULL", "(Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 133) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logI2L", "()V"));
        } else if (current.getOpcode() == 146) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logI2C", "()V"));
        } else if (current.getOpcode() == 145) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logI2B", "()V"));
        } else if (current.getOpcode() == 179) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logPUTSTATIC", "()V"));
        } else if (current.getOpcode() == 180) {
            instructionList.add(Instrumenter.createLogFieldInstrumentation((FieldInsnNode)current, "logGETFIELD", methodIndentifierIndex));
        } else if (current.getOpcode() == 181) {
            String owner = ((FieldInsnNode)current).owner;
            String desc = ((FieldInsnNode)current).desc;
            String name = ((FieldInsnNode)current).name;
            instructionList.add(new LdcInsnNode(owner));
            instructionList.add(new LdcInsnNode(desc));
            instructionList.add(new LdcInsnNode(name));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logPUTFIELD", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
        } else if (current.getOpcode() == 190) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logARRAYLENGTH", "()V"));
        } else if (current.getOpcode() == 191) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logATHROW", "()V"));
        } else if (current.getOpcode() == 132) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logIINC", "()V"));
        } else if (current.getOpcode() == 131) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLXOR", "()V"));
        } else if (current.getOpcode() == 136) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logL2I", "()V"));
        } else if (current.getOpcode() == 194) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logMONITORENTER", "()V"));
        } else if (current.getOpcode() == 195) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logMONITOREXIT", "()V"));
        } else if (current.getOpcode() == 144) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logD2F", "()V"));
        } else if (current.getOpcode() == 142) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logD2I", "()V"));
        } else if (current.getOpcode() == 143) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logD2L", "()V"));
        } else if (current.getOpcode() == 99) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDADD", "()V"));
        } else if (current.getOpcode() == 49) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDALOAD", "()V"));
        } else if (current.getOpcode() == 82) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDASTORE", "()V"));
        } else if (current.getOpcode() == 152) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDCMPG", "()V"));
        } else if (current.getOpcode() == 151) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDCMPL", "()V"));
        } else if (current.getOpcode() == 14) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDCONST_0", "()V"));
        } else if (current.getOpcode() == 15) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDCONST_1", "()V"));
        } else if (current.getOpcode() == 111) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDDIV", "()V"));
        } else if (current.getOpcode() == 24) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDLOAD", "(I)V"));
        } else if (current.getOpcode() == 107) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDMUL", "()V"));
        } else if (current.getOpcode() == 119) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDNEG", "()V"));
        } else if (current.getOpcode() == 115) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDREM", "()V"));
        } else if (current.getOpcode() == 175) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDRETURN", "()V"));
        } else if (current.getOpcode() == 57) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDSTORE", "(I)V"));
        } else if (current.getOpcode() == 103) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logDSUB", "()V"));
        } else if (current.getOpcode() == 139) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logF2I", "()V"));
        } else if (current.getOpcode() == 140) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logF2L", "()V"));
        } else if (current.getOpcode() == 98) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFADD", "()V"));
        } else if (current.getOpcode() == 48) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFALOAD", "()V"));
        } else if (current.getOpcode() == 81) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFASTORE", "()V"));
        } else if (current.getOpcode() == 150) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFCMPG", "()V"));
        } else if (current.getOpcode() == 149) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFCMPL", "()V"));
        } else if (current.getOpcode() == 11) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFCONST_0", "()V"));
        } else if (current.getOpcode() == 12) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFCONST_1", "()V"));
        } else if (current.getOpcode() == 13) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFCONST_2", "()V"));
        } else if (current.getOpcode() == 110) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFDIV", "()V"));
        } else if (current.getOpcode() == 23) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFLOAD", "(I)V"));
        } else if (current.getOpcode() == 106) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFMUL", "()V"));
        } else if (current.getOpcode() == 118) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFNEG", "()V"));
        } else if (current.getOpcode() == 114) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFREM", "()V"));
        } else if (current.getOpcode() == 174) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFRETURN", "()V"));
        } else if (current.getOpcode() == 56) {
            instructionList.add(new IntInsnNode(17, ((VarInsnNode)current).var));
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFSTORE", "(I)V"));
        } else if (current.getOpcode() == 102) {
            instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logFSUB", "()V"));
        }
        return instructionList;
    }

    private static InsnList createLogFieldInstrumentation(FieldInsnNode current, String loggerMethodName, int methodIndentifierIndex) {
        InsnList instructionList = new InsnList();
        instructionList.add(new LdcInsnNode(current.owner));
        instructionList.add(new LdcInsnNode(current.desc));
        instructionList.add(new LdcInsnNode(current.name));
        instructionList.add(new IntInsnNode(16, methodIndentifierIndex));
        instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, loggerMethodName, "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V"));
        return instructionList;
    }

    private static InsnList createLogInvokeMethodInstrumentation(MethodInsnNode current, String loggerMethodName, int methodIndentifierIndex) {
        InsnList instructionList = new InsnList();
        String s = current.owner + '|' + current.name + '|' + current.desc;
        instructionList.add(new LdcInsnNode(s));
        instructionList.add(new IntInsnNode(16, methodIndentifierIndex));
        instructionList.add(new MethodInsnNode(184, LOGGER_LOCATION, loggerMethodName, "(Ljava/lang/Object;I)V"));
        return instructionList;
    }

    private static InsnList createTableSwitchInstrumentation(TableSwitchInsnNode current) {
        InsnList insnList = new InsnList();
        insnList.add(new IntInsnNode(17, current.min));
        insnList.add(new IntInsnNode(17, current.max));
        insnList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logTABLESWITCH", "(II)V"));
        return insnList;
    }

    private static InsnList createLookupSwitchInstrumentation(LookupSwitchInsnNode current) {
        int i;
        InsnList insnList = new InsnList();
        List keys = current.keys;
        List labels = current.labels;
        LabelNode dflt = current.dflt;
        insnList.add(new IntInsnNode(17, keys.size()));
        insnList.add(new TypeInsnNode(189, "java/lang/Integer"));
        for (i = 0; i < keys.size(); ++i) {
            insnList.add(new InsnNode(89));
            insnList.add(new IntInsnNode(17, i));
            insnList.add(new LdcInsnNode(keys.get(i)));
            insnList.add(new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"));
            insnList.add(new InsnNode(83));
        }
        insnList.add(new MethodInsnNode(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;"));
        insnList.add(new IntInsnNode(16, labels.size()));
        insnList.add(new TypeInsnNode(189, "java/lang/String"));
        for (i = 0; i < labels.size(); ++i) {
            insnList.add(new InsnNode(89));
            insnList.add(new IntInsnNode(17, i));
            insnList.add(new LdcInsnNode(((LabelNode)labels.get(i)).getLabel().toString()));
            insnList.add(new InsnNode(83));
        }
        insnList.add(new MethodInsnNode(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;"));
        insnList.add(new LdcInsnNode(dflt.getLabel().toString()));
        insnList.add(new MethodInsnNode(184, LOGGER_LOCATION, "logLOOKUPSWITCH", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V"));
        return insnList;
    }

    static {
        LOGGER_LOCATION = "org/tsers/junitquest/Logger";
    }
}

