/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tsers.junitquest.ExecutionPath;
import org.tsers.junitquest.InfiniteLoopException;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.LoggerState;

public class Logger {
    private static ArrayList<LoggerState> path = new ArrayList();
    private static final int MAX_TIME_BEFORE_ABORT_INVOCATION = 1000;
    private static final int MAX_PATH_SIZE = 500;

    public static void logBEGINMETHOD(String methodDesc) {
        path.add(new LoggerState(Jutil.BEGIN_METHOD_OPCODE, methodDesc));
    }

    public static void logILOAD(int operand) {
        path.add(new LoggerState(21, operand));
    }

    public static void logLLOAD(int operand) {
        path.add(new LoggerState(22, operand));
    }

    public static void logACONST_NULL() {
        path.add(new LoggerState(1, null));
    }

    public static void logICONST_M1() {
        path.add(new LoggerState(2, null));
    }

    public static void logICONST_0() {
        path.add(new LoggerState(3, null));
    }

    public static void logICONST_1() {
        path.add(new LoggerState(4, null));
    }

    public static void logICONST_2() {
        path.add(new LoggerState(5, null));
    }

    public static void logICONST_3() {
        path.add(new LoggerState(6, null));
    }

    public static void logICONST_4() {
        path.add(new LoggerState(7, null));
    }

    public static void logICONST_5() {
        path.add(new LoggerState(8, null));
    }

    public static void logLCONST_0() {
        path.add(new LoggerState(9, null));
    }

    public static void logLCONST_1() {
        path.add(new LoggerState(10, null));
    }

    public static void logBIPUSH(int operand) {
        path.add(new LoggerState(16, operand));
    }

    public static void logSIPUSH(int operand) {
        path.add(new LoggerState(17, operand));
    }

    public static void logIADD() {
        path.add(new LoggerState(96, null));
    }

    public static void logLADD() {
        path.add(new LoggerState(96, null));
    }

    public static void logISUB() {
        path.add(new LoggerState(100, null));
    }

    public static void logLSUB() {
        path.add(new LoggerState(101, null));
    }

    public static void logIDIV() {
        path.add(new LoggerState(108, null));
    }

    public static void logIMUL() {
        path.add(new LoggerState(104, null));
    }

    public static void logIREM() {
        path.add(new LoggerState(112, null));
    }

    public static void logINEG() {
        path.add(new LoggerState(116, null));
    }

    public static void logLNEG() {
        path.add(new LoggerState(117, null));
    }

    public static void logLMUL() {
        path.add(new LoggerState(105, null));
    }

    public static void logLDIV() {
        path.add(new LoggerState(109, null));
    }

    public static void logLCMP() {
        path.add(new LoggerState(148, null));
    }

    public static void logISTORE(int operand) {
        path.add(new LoggerState(54, operand));
    }

    public static void logLSTORE(int operand) {
        path.add(new LoggerState(55, operand));
    }

    public static void logIFNE(String label) {
        path.add(new LoggerState(154, label));
    }

    public static void logIFLE(String label) {
        path.add(new LoggerState(158, label));
    }

    public static void logIFGE(String label) {
        path.add(new LoggerState(156, label));
    }

    public static void logIFGT(String label) {
        path.add(new LoggerState(157, label));
    }

    public static void logIFLT(String label) {
        path.add(new LoggerState(155, label));
    }

    public static void logIF_ICMPNE(String label) {
        path.add(new LoggerState(160, label));
    }

    public static void logIF_ICMPGE(String label) {
        path.add(new LoggerState(162, label));
    }

    public static void logIF_ICMPGT(String label) {
        path.add(new LoggerState(163, label));
    }

    public static void logIF_ICMPLE(String label) {
        path.add(new LoggerState(164, label));
    }

    public static void logIF_ICMPLT(String label) {
        path.add(new LoggerState(161, label));
    }

    public static void logIF_ICMPEQ(String label) {
        path.add(new LoggerState(159, label));
    }

    public static void logIF_ACMPEQ(String label) {
        path.add(new LoggerState(165, label));
    }

    public static void logIF_ACMPNE(String label) {
        path.add(new LoggerState(166, label));
    }

    public static void logGOTO(String label) {
        path.add(new LoggerState(167, label));
    }

    public static void logTABLESWITCH(int min, int max) {
        path.add(new LoggerState(170, Arrays.asList(min, max)));
    }

    public static void logRETURN() {
        path.add(new LoggerState(177, null));
    }

    public static void logIRETURN() {
        path.add(new LoggerState(172, null));
    }

    public static void logARETURN() {
        path.add(new LoggerState(176, null));
    }

    public static void logLRETURN() {
        path.add(new LoggerState(173, null));
    }

    public static void logGETSTATIC(Object descr) {
        path.add(new LoggerState(178, descr));
    }

    public static void logLDC(int cst) {
        path.add(new LoggerState(18, cst));
    }

    public static void logLDC(long cst) {
        path.add(new LoggerState(18, cst));
    }

    public static void logLDC(String cst) {
        path.add(new LoggerState(18, cst));
    }

    public static void logLOOKUPSWITCH(List<Integer> keys, List<String> labels, String dflt) {
        path.add(new LoggerState(171, Arrays.asList(keys, labels, dflt)));
    }

    public static void logINVOKEVIRTUAL(Object descr, int index) {
        path.add(new LoggerState(182, descr, index));
    }

    public static void logINVOKESPECIAL(Object descr, int index) {
        path.add(new LoggerState(183, descr, index));
    }

    public static void logINVOKESTATIC(Object descr, int index) {
        path.add(new LoggerState(184, descr, index));
    }

    public static void logINVOKEINTERFACE(Object desc, int index) {
        path.add(new LoggerState(185, desc, index));
    }

    public static void logNEW(Object descr) {
        path.add(new LoggerState(187, descr));
    }

    public static void logNEWARRAY(Object descr) {
        path.add(new LoggerState(188, descr));
    }

    public static void logANEWARRAY() {
        path.add(new LoggerState(189, null));
    }

    public static void logPOP() {
        path.add(new LoggerState(87, null));
    }

    public static void logPOP2() {
        path.add(new LoggerState(88, null));
    }

    public static void logDUP() {
        path.add(new LoggerState(89, null));
    }

    public static void logDUP_X1() {
        path.add(new LoggerState(90, null));
    }

    public static void logAASTORE() {
        path.add(new LoggerState(83, null));
    }

    public static void logAALOAD() {
        path.add(new LoggerState(50, null));
    }

    public static void logASTORE(int operand) {
        path.add(new LoggerState(58, operand));
    }

    public static void logALOAD(int operand) {
        path.add(new LoggerState(25, operand));
    }

    public static void logIALOAD() {
        path.add(new LoggerState(46, null));
    }

    public static void IASTORE() {
        path.add(new LoggerState(79, null));
    }

    public static void logBALOAD() {
        path.add(new LoggerState(51, null));
    }

    public static void logCASTORE() {
        path.add(new LoggerState(85, null));
    }

    public static void logCALOAD() {
        path.add(new LoggerState(52, null));
    }

    public static void logBASTORE() {
        path.add(new LoggerState(84, null));
    }

    public static void logIAND() {
        path.add(new LoggerState(126, null));
    }

    public static void logIOR() {
        path.add(new LoggerState(128, null));
    }

    public static void logIXOR() {
        path.add(new LoggerState(130, null));
    }

    public static void logISHL() {
        path.add(new LoggerState(120, null));
    }

    public static void logINSTANCEOF(String instance) {
        path.add(new LoggerState(193, instance));
    }

    public static void logIFEQ(String label) {
        path.add(new LoggerState(153, label));
    }

    public static void logLabel(String label) {
        path.add(new LoggerState(-1, label));
    }

    public static void logCHECKCAST(String desc) {
        path.add(new LoggerState(192, desc));
    }

    public static void logIFNULL(String label) {
        path.add(new LoggerState(198, label));
    }

    public static void logIFNONNULL(String label) {
        path.add(new LoggerState(199, label));
    }

    public static void logI2L() {
        path.add(new LoggerState(133, null));
    }

    public static void logI2C() {
        path.add(new LoggerState(146, null));
    }

    public static void logI2B() {
        path.add(new LoggerState(145, null));
    }

    public static void logPUTSTATIC() {
        path.add(new LoggerState(179, null));
    }

    public static void logGETFIELD(String owner, String desc, String name, int index) {
        path.add(new LoggerState(180, Arrays.asList(owner, desc, name), index));
    }

    public static void logPUTFIELD(String owner, String desc, String name) {
        path.add(new LoggerState(181, Arrays.asList(owner, desc, name)));
    }

    public static void logARRAYLENGTH() {
        path.add(new LoggerState(190, null));
    }

    public static void logATHROW() {
        path.add(new LoggerState(191, null));
    }

    public static void logIINC() {
        path.add(new LoggerState(132, null));
    }

    public static void logLXOR() {
        path.add(new LoggerState(131, null));
    }

    public static void logIUSHR() {
        path.add(new LoggerState(124, null));
    }

    public static void logL2I() {
        path.add(new LoggerState(136, null));
    }

    public static void logMONITORENTER() {
        path.add(new LoggerState(194, null));
    }

    public static void logMONITOREXIT() {
        path.add(new LoggerState(195, null));
    }

    public static void logD2F() {
        path.add(new LoggerState(144, null));
    }

    public static void logD2I() {
        path.add(new LoggerState(142, null));
    }

    public static void logD2L() {
        path.add(new LoggerState(143, null));
    }

    public static void logDADD() {
        path.add(new LoggerState(99, null));
    }

    public static void logDALOAD() {
        path.add(new LoggerState(49, null));
    }

    public static void logDASTORE() {
        path.add(new LoggerState(82, null));
    }

    public static void logDCMPG() {
        path.add(new LoggerState(152, null));
    }

    public static void logDCMPL() {
        path.add(new LoggerState(151, null));
    }

    public static void logDCONST_0() {
        path.add(new LoggerState(14, null));
    }

    public static void logDCONST_1() {
        path.add(new LoggerState(15, null));
    }

    public static void logDDIV() {
        path.add(new LoggerState(111, null));
    }

    public static void logDLOAD(int operand) {
        path.add(new LoggerState(24, operand));
    }

    public static void logDMUL() {
        path.add(new LoggerState(107, null));
    }

    public static void logDNEG() {
        path.add(new LoggerState(119, null));
    }

    public static void logDREM() {
        path.add(new LoggerState(115, null));
    }

    public static void logDRETURN() {
        path.add(new LoggerState(175, null));
    }

    public static void logDSTORE(int operand) {
        path.add(new LoggerState(57, operand));
    }

    public static void logDSUB() {
        path.add(new LoggerState(103, null));
    }

    public static void logF2D() {
        path.add(new LoggerState(141, null));
    }

    public static void logF2I() {
        path.add(new LoggerState(139, null));
    }

    public static void logF2L() {
        path.add(new LoggerState(140, null));
    }

    public static void logFADD() {
        path.add(new LoggerState(98, null));
    }

    public static void logFALOAD() {
        path.add(new LoggerState(48, null));
    }

    public static void logFASTORE() {
        path.add(new LoggerState(81, null));
    }

    public static void logFCMPG() {
        path.add(new LoggerState(150, null));
    }

    public static void logFCMPL() {
        path.add(new LoggerState(149, null));
    }

    public static void logFCONST_0() {
        path.add(new LoggerState(11, null));
    }

    public static void logFCONST_1() {
        path.add(new LoggerState(12, null));
    }

    public static void logFCONST_2() {
        path.add(new LoggerState(13, null));
    }

    public static void logFDIV() {
        path.add(new LoggerState(110, null));
    }

    public static void logFLOAD(int operand) {
        path.add(new LoggerState(23, operand));
    }

    public static void logFMUL() {
        path.add(new LoggerState(106, null));
    }

    public static void logFNEG() {
        path.add(new LoggerState(118, null));
    }

    public static void logFREM() {
        path.add(new LoggerState(114, null));
    }

    public static void logFRETURN() {
        path.add(new LoggerState(174, null));
    }

    public static void logFSTORE(int operand) {
        path.add(new LoggerState(56, operand));
    }

    public static void logFSUB() {
        path.add(new LoggerState(102, null));
    }

    public static void logStackTop(int stackTop, int i) {
        LoggerState state = path.stream().filter(p -> p.getIdentifier() == i).findAny().orElseThrow(() -> new RuntimeException("Cannot find method when logging stack top after returning from method"));
        state.setReturnValue(stackTop);
    }

    public static ExecutionPath getExecutionPath(final AccessibleObject ao, final Object ... params) throws InfiniteLoopException, InterruptedException {
        Thread r = new Thread(){

            @Override
            public void run() {
                try {
                    Logger.invokeAccessibleObject(ao, params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        r.start();
        r.join(1000L);
        if (r.isAlive()) {
            r.stop();
            throw new InfiniteLoopException();
        }
        if (path.size() > 500) {
            throw new InfiniteLoopException();
        }
        return new ExecutionPath(path);
    }

    private static void invokeAccessibleObject(AccessibleObject ao, Object[] params) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (ao instanceof Method) {
            Logger.invokeMethod((Method)ao, params);
        } else if (ao instanceof Constructor) {
            Logger.invokeConstructor((Constructor)ao, params);
        }
    }

    private static void invokeConstructor(Constructor ao, Object[] params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Logger.beginMethodLogging();
        Object[] callParams = Logger.shiftLeftIfNotStatic(ao, params);
        ao.newInstance(callParams);
    }

    private static void invokeMethod(Method ao, Object[] params) throws IllegalAccessException, InvocationTargetException {
        Method m = ao;
        Object classInstance = Logger.getClassInstance(m, params);
        Object[] callParams = Logger.shiftLeftIfNotStatic(m, params);
        Logger.beginMethodLogging();
        m.invoke(classInstance, callParams);
    }

    public static Object[] shiftLeftIfNotStatic(AccessibleObject m, Object[] params) {
        if (Jutil.isStatic(m)) {
            return params;
        }
        return Jutil.shiftLeft(params);
    }

    private static Object getClassInstance(Method m, Object[] params) {
        if (Jutil.isStatic(m)) {
            return null;
        }
        return params[0];
    }

    private static void beginMethodLogging() {
        path = new ArrayList();
    }
}

