/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.util.Optional;
import org.tsers.junitquest.OpcodeHelper;

public class LoggerState {
    private final int opcode;
    private int identifier;
    private final Object operand;
    Optional<Object> returnValue;

    public LoggerState(int opcode, Object operand, int identifier) {
        this.opcode = opcode;
        this.operand = operand;
        this.returnValue = Optional.empty();
        this.identifier = identifier;
    }

    public LoggerState(int opcode, Object operand) {
        this.opcode = opcode;
        this.operand = operand;
        this.returnValue = Optional.empty();
        this.identifier = -1;
    }

    public Optional<Object> getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = Optional.of(returnValue);
    }

    public String stateAsString() {
        return OpcodeHelper.getName(this.opcode) + " " + (this.operand == null ? "" : this.operand);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Object getOperand() {
        return this.operand;
    }

    public int getIdentifier() {
        return this.identifier;
    }
}

