/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tsers.junitquest.CallParam;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.instance.ClassInstance;
import org.tsers.junitquest.instance.Instance;
import org.tsers.junitquest.instance.NullInstance;
import org.tsers.junitquest.instance.ObjectInstance;
import org.tsers.junitquest.instance.PrimitiveInstance;

public class TestCaseGenerator {
    private static int variableCounter = 0;
    private static final String INDENT_1 = "  ";
    private static final String INDENT_2 = "    ";
    private static HashMap<String, Integer> methodCounter = new HashMap();

    private static void resetVariableCounter() {
        variableCounter = 0;
    }

    private static void resetMethodCounter() {
        methodCounter = new HashMap();
    }

    private static int nextVariable() {
        return ++variableCounter;
    }

    private static int nextMethod(String methodName) {
        if (methodCounter.containsKey(methodName)) {
            int n = methodCounter.get(methodName);
            methodCounter.put(methodName, ++n);
            return n;
        }
        int n = 0;
        methodCounter.put(methodName, n);
        return n;
    }

    public static String wrapToTestClass(String methods, String className) {
        TestCaseGenerator.resetMethodCounter();
        return "import org.junit.Test;\npublic class " + className + "Test" + " {\n\n" + methods + "\n}";
    }

    public static String toTestCase(List<List<CallParam>> callParams, Class clazz, String methodName, String methodDesc) throws NoSuchMethodException {
        AccessibleObject method = Jutil.getAccessibleObject(clazz, methodName, methodDesc);
        String s = callParams.stream().map(cp -> TestCaseGenerator.createRootCallParam(method, clazz, cp)).map(cp -> TestCaseGenerator.callParamToJavaCode(cp, "mainVar")).map(c -> TestCaseGenerator.wrapToTestCase(TestCaseGenerator.getMethodNameForTestCase(method) + "Test" + TestCaseGenerator.nextMethod(methodName), c)).reduce("", (a, b) -> a + b);
        return s;
    }

    private static String getMethodNameForTestCase(AccessibleObject ao) {
        if (ao instanceof Method) {
            return ((Method)ao).getName();
        }
        if (ao instanceof Constructor) {
            return "constructor";
        }
        throw new RuntimeException();
    }

    private static CallParam createRootCallParam(AccessibleObject method, Class className, List<CallParam> cps) {
        if (method instanceof Method) {
            return new CallParam(new ObjectInstance((Method)method, className, cps.stream().map(cp -> cp.getInstance()).collect(Collectors.toList())), 0);
        }
        if (method instanceof Constructor) {
            return new CallParam(new ObjectInstance((Constructor)method, cps.stream().skip(1L).map(cp -> cp.getInstance()).collect(Collectors.toList())), 0);
        }
        throw new RuntimeException("Cannot create root call parameter: " + method + " " + className);
    }

    private static String wrapToTestCase(String testName, String javaCode) {
        String a = "  @Test\n  public void " + testName + "() throws Exception {";
        String b = "\n  }\n\n";
        return a + javaCode + b;
    }

    private static String primitiveInstanceToVariableType(PrimitiveInstance instance) {
        if (instance.getInstance() instanceof Integer) {
            return "int";
        }
        if (instance.getInstance() instanceof Boolean) {
            return "boolean";
        }
        if (instance.getInstance() instanceof Long) {
            return "long";
        }
        if (instance.getInstance() instanceof Character) {
            return "char";
        }
        if (instance.getInstance() instanceof Double) {
            return "double";
        }
        if (instance.getInstance() instanceof Short) {
            return "short";
        }
        if (instance.getInstance() instanceof Float) {
            return "float";
        }
        if (instance.getInstance() instanceof Byte) {
            return "byte";
        }
        throw new RuntimeException("Unknown primitive instance");
    }

    private static String getClassName(Instance instance) {
        if (instance instanceof PrimitiveInstance) {
            return TestCaseGenerator.primitiveInstanceToVariableType((PrimitiveInstance)instance);
        }
        if (instance instanceof NullInstance) {
            return "Object";
        }
        if (((ObjectInstance)instance).getMethod() instanceof Method) {
            Method m = (Method)((ObjectInstance)instance).getMethod();
            if (Jutil.isStatic(m)) {
                return TestCaseGenerator.handleArraysInDeclarationName(m.getReturnType().getName());
            }
            return TestCaseGenerator.handleArraysInDeclarationName(m.getDeclaringClass().getName());
        }
        return TestCaseGenerator.handleArraysInDeclarationName(((Constructor)((ObjectInstance)instance).getMethod()).getDeclaringClass().getName());
    }

    private static String handleArraysInDeclarationName(String decl) {
        if (decl.startsWith("[L")) {
            decl = decl.substring(2);
            decl = decl.substring(0, decl.length() - 1);
            decl = decl + "[]";
        } else if (decl.startsWith("[")) {
            decl = decl.substring(1);
            decl = decl.substring(0, decl.length() - 1);
            decl = decl + "[]";
        }
        return decl;
    }

    private static String getOnlyMethodName(ObjectInstance instance) {
        Method m = (Method)instance.getMethod();
        return m.getName();
    }

    private static String getMethodName(ObjectInstance instance) {
        Method m = (Method)instance.getMethod();
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    public static String callParamToJavaCode(CallParam cp, String varName) {
        TestCaseGenerator.resetVariableCounter();
        return TestCaseGenerator.getParamNameAndCode(cp.getInstance(), Object.class).getValue();
    }

    private static boolean isMethodCall(Instance instance) {
        if (instance instanceof ObjectInstance) {
            return ((ObjectInstance)instance).getMethod() instanceof Method;
        }
        return false;
    }

    private static boolean isVirtualMethodCall(Instance instance) {
        ObjectInstance oi;
        if (instance instanceof ObjectInstance && (oi = (ObjectInstance)instance).getMethod() instanceof Method) {
            Method m = (Method)oi.getMethod();
            return !Jutil.isStatic(m);
        }
        return false;
    }

    private static boolean isStaticMethodCall(Instance instance) {
        ObjectInstance oi;
        if (instance instanceof ObjectInstance && (oi = (ObjectInstance)instance).getMethod() instanceof Method) {
            Method m = (Method)oi.getMethod();
            return Jutil.isStatic(m);
        }
        return false;
    }

    private static boolean isConstructor(Instance instance) {
        ObjectInstance oi;
        return instance instanceof ObjectInstance && (oi = (ObjectInstance)instance).getMethod() instanceof Constructor;
    }

    private static boolean isVoidMethodCall(Instance instance) {
        ObjectInstance oi;
        if (instance instanceof ObjectInstance && (oi = (ObjectInstance)instance).getMethod() instanceof Method) {
            Method m = (Method)oi.getMethod();
            return m.getReturnType().equals(Void.TYPE);
        }
        return false;
    }

    private static String getPostfix(Instance instance) {
        if (TestCaseGenerator.isMethodCall(instance)) {
            return TestCaseGenerator.getMethodName((ObjectInstance)instance);
        }
        return TestCaseGenerator.getClassName(instance);
    }

    private static Map.Entry<String, String> getParamNameAndCode(Instance param, Class paramType) {
        String variableName = "var" + TestCaseGenerator.nextVariable();
        if (param instanceof NullInstance) {
            String s = Jutil.getJavaName(paramType.getName()) + " " + variableName + " = null;";
            return new AbstractMap.SimpleEntry<String, String>(variableName, s);
        }
        if (param instanceof PrimitiveInstance) {
            String s = TestCaseGenerator.getClassName(param) + " " + variableName + " = " + param.asString() + ";";
            return new AbstractMap.SimpleEntry<String, String>(variableName, s);
        }
        if (param instanceof ClassInstance) {
            return new AbstractMap.SimpleEntry<String, String>(variableName, "Class " + variableName + " = " + param.asString() + ";");
        }
        if (param instanceof ObjectInstance) {
            return new AbstractMap.SimpleEntry<String, String>(variableName, TestCaseGenerator.createFromObjectInstance((ObjectInstance)param, variableName));
        }
        throw new RuntimeException("what to do?");
    }

    private static String createFromObjectInstance(ObjectInstance instance, String var) {
        List<Map.Entry<String, String>> params = TestCaseGenerator.getParamEntrys(instance);
        String codeTocreateCallVars = params.stream().map(e -> (String)e.getValue()).reduce(INDENT_2, (a, b) -> a + "\n" + INDENT_2 + b);
        String callVars = "(" + params.stream().map(e -> (String)e.getKey()).collect(Collectors.joining(", ")) + ")";
        if (TestCaseGenerator.isVirtualMethodCall(instance)) {
            Map.Entry<String, String> virtualInstance = TestCaseGenerator.getParamNameAndCode(instance.getParameters().get(0), Object.class);
            return codeTocreateCallVars + INDENT_2 + virtualInstance.getValue() + "\n" + INDENT_2 + virtualInstance.getKey() + "." + TestCaseGenerator.getOnlyMethodName(instance) + callVars + ";";
        }
        if (TestCaseGenerator.isArrayCall(instance)) {
            String varType = Jutil.getJavaName(instance.getParameters().get(0).build().toString());
            return codeTocreateCallVars + varType + "[] " + var + " = " + "(" + varType + "[]" + ") " + TestCaseGenerator.getMethodName(instance) + callVars + ";";
        }
        if (TestCaseGenerator.isVoidMethodCall(instance)) {
            return codeTocreateCallVars + "\n" + INDENT_2 + TestCaseGenerator.getPostfix(instance) + callVars + ";";
        }
        if (TestCaseGenerator.isConstructor(instance)) {
            return codeTocreateCallVars + "\n" + INDENT_2 + TestCaseGenerator.getClassName(instance) + " " + var + " = new " + TestCaseGenerator.getClassName(instance) + callVars + ";";
        }
        if (TestCaseGenerator.isStaticMethodCall(instance)) {
            return codeTocreateCallVars + "\n" + INDENT_2 + TestCaseGenerator.getClassName(instance) + " " + var + " = " + TestCaseGenerator.getMethodName(instance) + callVars + ";";
        }
        throw new RuntimeException("Cannot create code for object");
    }

    private static List<Map.Entry<String, String>> getParamEntrys(ObjectInstance instance) {
        int virtualMethodPrefix = 0;
        if (TestCaseGenerator.isVirtualMethodCall(instance)) {
            ++virtualMethodPrefix;
        }
        ArrayList<Map.Entry<String, String>> params = new ArrayList<Map.Entry<String, String>>();
        for (int i = virtualMethodPrefix; i < instance.getParameters().size(); ++i) {
            Class type = Jutil.getParameterTypes(instance.getMethod())[i - virtualMethodPrefix];
            Instance param = instance.getParameters().get(i);
            params.add(TestCaseGenerator.getParamNameAndCode(param, type));
        }
        return params;
    }

    private static boolean isArrayCall(Instance instance) {
        AccessibleObject ao;
        return instance instanceof ObjectInstance && (ao = ((ObjectInstance)instance).getMethod()) instanceof Method && ((Method)ao).getDeclaringClass().getName().equals("java.lang.reflect.Array");
    }
}

