/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.expr;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.tsers.junitquest.expr.ExprNode;

public class GetFieldNode
extends ExprNode {
    private final String className;
    private final String fieldName;
    private final Optional<Object> returnValue;

    public GetFieldNode(ExprNode child, String className, String fieldName, Optional<Object> returnValue) {
        super(Arrays.asList(child));
        this.className = className;
        this.fieldName = fieldName;
        this.returnValue = returnValue;
    }

    public Optional<Object> getReturnValue() {
        return this.returnValue;
    }

    @Override
    public ExprNode copy(List<ExprNode> newchildren) {
        return new GetFieldNode(newchildren.get(0), this.className, this.fieldName, this.returnValue);
    }

    @Override
    public boolean equals(ExprNode exprNode) {
        if (exprNode.getClass().equals(this.getClass())) {
            GetFieldNode gfn = (GetFieldNode)exprNode;
            if (!gfn.className.equals(this.className) || !gfn.fieldName.equals(this.fieldName)) {
                return false;
            }
            return this.childrenEquals(exprNode.getChildren());
        }
        return false;
    }
}

