/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.expr;

import java.util.List;
import java.util.Optional;
import org.tsers.junitquest.expr.ExprNode;
import org.tsers.junitquest.expr.InvokeVirtualNode;

public abstract class InvokeMethodNode
extends ExprNode {
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private final Optional<Object> returnValue;

    public InvokeMethodNode(List<ExprNode> children, String className, String methodName, String methodDesc, Optional<Object> returnValue) {
        super(children);
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.returnValue = returnValue;
    }

    public Optional<Object> getReturnValue() {
        return this.returnValue;
    }

    @Override
    public ExprNode copy(List<ExprNode> newchildren) {
        return new InvokeVirtualNode(newchildren, this.className, this.methodName, this.methodDesc, this.returnValue);
    }

    @Override
    public boolean equals(ExprNode exprNode) {
        if (exprNode.getClass().equals(this.getClass())) {
            InvokeMethodNode iv = (InvokeMethodNode)exprNode;
            if (!(iv.className.equals(this.className) && iv.methodName.equals(this.methodName) && iv.methodDesc.equals(this.methodDesc))) {
                return false;
            }
            return this.childrenEquals(exprNode.getChildren());
        }
        return false;
    }
}

