/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.finder;

import java.io.File;

public class FileToClassConverter {
    private final String classPathRoot;
    private final ClassLoader classLoader;

    public FileToClassConverter(String classPathRoot, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classPathRoot = classPathRoot;
    }

    public Class convertToClass(File classFile) {
        Class classInstance = null;
        if (classFile.getAbsolutePath().startsWith(this.classPathRoot) && classFile.getAbsolutePath().endsWith(".class")) {
            classInstance = this.getClassFromName(classFile.getAbsolutePath());
        }
        return classInstance;
    }

    private Class getClassFromName(String fileName) {
        try {
            String className = this.removeClassPathBase(fileName);
            className = FileToClassConverter.removeExtension(className);
            return this.classLoader.loadClass(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String removeClassPathBase(String fileName) {
        int prefix = 0;
        if (!this.classPathRoot.endsWith("/")) {
            ++prefix;
        }
        String classPart = fileName.substring(this.classPathRoot.length() + prefix);
        String className = classPart.replace(File.separatorChar, '.');
        return className;
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String modifiedName = fileName;
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            modifiedName = fileName.substring(0, index);
        }
        return modifiedName;
    }
}

