/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.finder;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tsers.junitquest.finder.FileToClassConverter;

public class FileWalker {
    private final String baseDir;
    private final FileToClassConverter converter;
    private final Class toFind;

    public FileWalker(String baseDir, ClassLoader cl, Class toFind) {
        this.baseDir = baseDir;
        this.toFind = toFind;
        this.converter = new FileToClassConverter(baseDir, cl);
    }

    public List<Class> walk() {
        File rootDir = new File(this.baseDir);
        return this.walk(rootDir);
    }

    protected List<Class> walk(File currentDir) {
        File[] files = currentDir.listFiles();
        if (files == null) {
            return new ArrayList<Class>();
        }
        ArrayList<Class> found = new ArrayList<Class>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                found.addAll(this.walk(file));
                continue;
            }
            found.addAll(this.handleFile(file));
        }
        return found;
    }

    public List<Class<?>> handleFile(File file) {
        try {
            Class<?>[] ifaces;
            Class clazz = this.converter.convertToClass(file);
            if (clazz == null) {
                Arrays.asList(new Object[0]);
            }
            for (Class<?> iface : ifaces = clazz.getInterfaces()) {
                String sfinding;
                String siface = ((Object)iface).toString();
                if (!siface.equals(sfinding = this.toFind.toString())) continue;
                return Arrays.asList(clazz);
            }
            if (this.toFind.isAssignableFrom(clazz)) {
                return Arrays.asList(clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Arrays.asList(new Class[0]);
    }
}

