/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.instance;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.instance.Instance;

public class ObjectInstance
implements Instance {
    final AccessibleObject method;
    final Object classInstance;
    final List<Instance> parameters;

    public ObjectInstance(Method method, Object classInstance, List<Instance> parameters) {
        this.method = method;
        this.classInstance = classInstance;
        this.parameters = parameters;
    }

    public ObjectInstance(Constructor constructor, List<Instance> parameters) {
        this.method = constructor;
        this.classInstance = null;
        this.parameters = parameters;
    }

    public AccessibleObject getMethod() {
        return this.method;
    }

    public List<Instance> getParameters() {
        return this.parameters;
    }

    @Override
    public Object build() {
        try {
            List builtParameters = this.parameters.stream().map(p -> p.build()).collect(Collectors.toList());
            Object[] oParameters = Jutil.listToArray(builtParameters);
            if (this.method instanceof Method) {
                return ((Method)this.method).invoke(this.classInstance, oParameters);
            }
            if (this.method instanceof Constructor) {
                return ((Constructor)this.method).newInstance(oParameters);
            }
            throw new RuntimeException("Cannot build instance");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getInstance() {
        return this.classInstance;
    }

    @Override
    public String asString() {
        if (this.method instanceof Constructor) {
            return this.toString();
        }
        return "asdf";
    }
}

