/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.junitquest.solver;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.tsers.junitquest.Jutil;
import org.tsers.junitquest.expr.AddNode;
import org.tsers.junitquest.expr.AndNode;
import org.tsers.junitquest.expr.ExprNode;

public class LogicalSolver {
    public static Function<ExprNode, ExprNode> reduceAdds = addNode -> {
        if (addNode instanceof AddNode && addNode.getChildren().size() == 1) {
            return LogicalSolver.combineNodes(addNode.getChildren().get(0), AddNode.class);
        }
        return LogicalSolver.combineNodes(addNode, AddNode.class);
    };
    public static Function<ExprNode, ExprNode> combineANDs = andNode -> LogicalSolver.combineNodes(andNode, AndNode.class);

    public static ExprNode combineNodes(ExprNode node, Class nodeClazz) {
        if (!node.getClass().isAssignableFrom(nodeClazz)) {
            return node;
        }
        List combinedNodes = node.getChildren().stream().filter(n -> n.getClass().isAssignableFrom(nodeClazz)).map(n -> n.getChildren()).flatMap(n -> n.stream()).collect(Collectors.toList());
        List otherNodes = node.getChildren().stream().filter(n -> !n.getClass().isAssignableFrom(nodeClazz)).collect(Collectors.toList());
        List newChildren = Jutil.combineLists(combinedNodes, otherNodes);
        ExprNode returnNode = null;
        try {
            Constructor c = nodeClazz.getConstructor(List.class);
            returnNode = (ExprNode)c.newInstance(newChildren);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find constructor: " + nodeClazz);
        }
        if (returnNode.getChildren().stream().anyMatch(n -> n.getClass().isAssignableFrom(nodeClazz))) {
            ExprNode newReturnNode = LogicalSolver.combineNodes(returnNode, nodeClazz);
            return newReturnNode;
        }
        return returnNode;
    }
}

